/*
 * Decompiled with CFR 0.152.
 */
package maprenderer;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import maprenderer.PMS_Collider;
import maprenderer.PMS_Color;
import maprenderer.PMS_Polygon;
import maprenderer.PMS_Prop;
import maprenderer.PMS_Spawn;
import maprenderer.PMS_Vector;
import maprenderer.PMS_Vertex;
import maprenderer.PMS_Waypoint;

public class PMS_Map {
    private String Title = "";
    private String Texture = "";
    private PMS_Color TopColor;
    private PMS_Color BottomColor;
    private int Jets;
    private int Grenades;
    private int MedKits;
    private int Weather;
    private int StepType;
    private int PolyCount;
    private PMS_Polygon[] Polys;
    private int PropCount;
    private PMS_Prop[] Props;
    private int SceneryCount;
    private String[] SceneryNames;
    private int[] DOSTime;
    private int[] DOSDate;
    private int ColliderCount;
    private PMS_Collider[] Colliders;
    private int SpawnpointCount;
    private PMS_Spawn[] Spawns;
    private int WayPointCount;
    private PMS_Waypoint[] wpts;
    private int SceneryLength;
    private int TitleLength;
    private int TextureLength;
    private int SectorCount;
    private int SectorPolyCount;
    private int SectorDivision;

    public String getTitle() {
        return this.Title;
    }

    public String getTexture() {
        return this.Texture;
    }

    public PMS_Color getTopColor() {
        return this.TopColor;
    }

    public PMS_Color getBottomColor() {
        return this.BottomColor;
    }

    public int getJets() {
        return this.Jets;
    }

    public int getGrenades() {
        return this.Grenades;
    }

    public int getMedKits() {
        return this.MedKits;
    }

    public int getWeather() {
        return this.Weather;
    }

    public int getStepType() {
        return this.StepType;
    }

    public int getPolyCount() {
        return this.PolyCount;
    }

    public PMS_Polygon getPoly(int i) {
        return this.Polys[i];
    }

    public PMS_Polygon[] getAllPolys() {
        return this.Polys;
    }

    public int getPropCount() {
        return this.PropCount;
    }

    public PMS_Prop getProp(int i) {
        return this.Props[i];
    }

    public PMS_Prop[] getAllProps() {
        return this.Props;
    }

    public int getSceneryCount() {
        return this.SceneryCount;
    }

    public String getSceneryName(int i) {
        return this.SceneryNames[i];
    }

    public String[] getAllSceneryNames() {
        return this.SceneryNames;
    }

    public int getDOSTime(int i) {
        return this.DOSTime[i];
    }

    public int[] getAllDOSTime() {
        return this.DOSTime;
    }

    public int getDOSDate(int i) {
        return this.DOSDate[i];
    }

    public int[] getAllDOSDate() {
        return this.DOSDate;
    }

    public int getColliderCount() {
        return this.ColliderCount;
    }

    public PMS_Collider getCollider(int i) {
        return this.Colliders[i];
    }

    public PMS_Collider[] getAllColliders() {
        return this.Colliders;
    }

    public int getSpawnCount() {
        return this.SpawnpointCount;
    }

    public PMS_Spawn getSpawn(int i) {
        return this.Spawns[i];
    }

    public PMS_Spawn[] getAllSpawns() {
        return this.Spawns;
    }

    public int getWayPointCount() {
        return this.WayPointCount;
    }

    public PMS_Waypoint getWayPoint(int i) {
        return this.wpts[i];
    }

    public PMS_Waypoint[] getAllWayPoints() {
        return this.wpts;
    }

    public int getSectorCount() {
        return this.SectorCount;
    }

    public int getSectorDivision() {
        return this.SectorDivision;
    }

    public PMS_Map(String Path2) {
        this(new File(Path2));
    }

    public PMS_Map(File map) {
        try {
            ByteBuffer buf = ByteBuffer.wrap(PMS_Map.getBytesFromFile(map));
            buf.order(ByteOrder.LITTLE_ENDIAN);
            this.read(buf);
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }

    private void read(ByteBuffer reader) throws IOException {
        int i;
        reader.getInt();
        this.TitleLength = reader.get();
        for (i = 0; i < this.TitleLength; ++i) {
            this.Title = this.Title + (char)reader.get();
        }
        for (i = 0; i < 38 - this.TitleLength; ++i) {
            reader.get();
        }
        this.TextureLength = reader.get();
        for (i = 0; i < this.TextureLength; ++i) {
            this.Texture = this.Texture + (char)reader.get();
        }
        for (i = 0; i < 24 - this.TextureLength; ++i) {
            reader.get();
        }
        this.TopColor = new PMS_Color(reader.get(), reader.get(), reader.get(), reader.get());
        this.BottomColor = new PMS_Color(reader.get(), reader.get(), reader.get(), reader.get());
        this.Jets = reader.getInt();
        this.Grenades = reader.get();
        this.MedKits = reader.get();
        this.Weather = reader.get();
        this.StepType = reader.get();
        reader.getInt();
        this.PolyCount = reader.getInt();
        this.Polys = new PMS_Polygon[this.PolyCount];
        for (i = 0; i < this.PolyCount; ++i) {
            PMS_Vertex[] TVert = new PMS_Vertex[3];
            PMS_Vector[] TVect = new PMS_Vector[3];
            TVert[0] = new PMS_Vertex(reader.getFloat(), reader.getFloat(), reader.getFloat(), reader.getFloat(), new PMS_Color(reader.get(), reader.get(), reader.get(), reader.get()), reader.getFloat(), reader.getFloat());
            TVert[1] = new PMS_Vertex(reader.getFloat(), reader.getFloat(), reader.getFloat(), reader.getFloat(), new PMS_Color(reader.get(), reader.get(), reader.get(), reader.get()), reader.getFloat(), reader.getFloat());
            TVert[2] = new PMS_Vertex(reader.getFloat(), reader.getFloat(), reader.getFloat(), reader.getFloat(), new PMS_Color(reader.get(), reader.get(), reader.get(), reader.get()), reader.getFloat(), reader.getFloat());
            TVect[0] = new PMS_Vector(reader.getFloat(), reader.getFloat(), reader.getFloat());
            TVect[1] = new PMS_Vector(reader.getFloat(), reader.getFloat(), reader.getFloat());
            TVect[2] = new PMS_Vector(reader.getFloat(), reader.getFloat(), reader.getFloat());
            this.Polys[i] = new PMS_Polygon(TVert, TVect, reader.get());
        }
        this.SectorDivision = reader.getInt();
        this.SectorCount = reader.getInt();
        for (i = 0; i < (this.SectorCount * 2 + 1) * (this.SectorCount * 2 + 1); ++i) {
            this.SectorPolyCount = reader.getShort();
            if (this.SectorPolyCount <= 0) continue;
            for (int p = 0; p < this.SectorPolyCount; ++p) {
                reader.getShort();
            }
        }
        this.PropCount = reader.getInt();
        this.Props = new PMS_Prop[this.PropCount];
        for (i = 0; i < this.PropCount; ++i) {
            this.Props[i] = new PMS_Prop(reader.get(), reader.get(), reader.getShort(), reader.getInt(), reader.getInt(), reader.getFloat(), reader.getFloat(), reader.getFloat(), reader.getFloat(), reader.getFloat(), reader.get(), reader.getShort() + reader.get(), new PMS_Color(reader.get(), reader.get(), reader.get(), reader.get()), reader.get());
            reader.getShort();
            reader.get();
        }
        this.SceneryCount = reader.getInt();
        this.SceneryNames = new String[this.SceneryCount];
        this.DOSTime = new int[this.SceneryCount];
        this.DOSDate = new int[this.SceneryCount];
        for (i = 0; i < this.SceneryCount; ++i) {
            int p;
            this.SceneryNames[i] = "";
            this.SceneryLength = reader.get();
            for (p = 0; p < this.SceneryLength; ++p) {
                this.SceneryNames[i] = this.SceneryNames[i] + (char)reader.get();
            }
            for (p = 0; p < 50 - this.SceneryLength; ++p) {
                reader.get();
            }
            this.DOSTime[i] = reader.getShort();
            this.DOSDate[i] = reader.getShort();
        }
        this.ColliderCount = reader.getInt();
        this.Colliders = new PMS_Collider[this.ColliderCount];
        for (i = 0; i < this.ColliderCount; ++i) {
            this.Colliders[i] = new PMS_Collider(reader.get(), reader.getShort() + reader.get(), reader.getFloat(), reader.getFloat(), reader.getFloat());
        }
        this.SpawnpointCount = reader.getInt();
        this.Spawns = new PMS_Spawn[this.SpawnpointCount];
        for (i = 0; i < this.SpawnpointCount; ++i) {
            this.Spawns[i] = new PMS_Spawn(reader.get(), reader.getShort() + reader.get(), reader.getInt(), reader.getInt(), reader.get());
            reader.getShort();
            reader.get();
        }
        this.WayPointCount = reader.getInt();
        this.wpts = new PMS_Waypoint[this.WayPointCount];
        for (i = 0; i < this.WayPointCount; ++i) {
            this.wpts[i] = new PMS_Waypoint(reader.get(), reader.getShort() + reader.get(), reader.getInt(), reader.getInt(), reader.getInt(), reader.get(), reader.get(), reader.get(), reader.get(), reader.get(), reader.get(), reader.get(), reader.get(), reader.get(), reader.getShort() + reader.get(), reader.getInt());
            for (int p = 0; p < 20; ++p) {
                reader.getInt();
            }
        }
    }

    public static byte[] getBytesFromFile(File file) throws IOException {
        FileInputStream is = new FileInputStream(file);
        long length = file.length();
        if (length > Integer.MAX_VALUE) {
            System.out.println("File too large");
        }
        byte[] bytes = new byte[(int)length];
        int numRead = 0;
        for (int offset = 0; offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
        }
        ((InputStream)is).close();
        return bytes;
    }
}

