/*
 * Decompiled with CFR 0.152.
 */
package pmsrenderer;

import com.jogamp.newt.event.WindowEvent;
import com.jogamp.opengl.util.Animator;
import com.sun.prism.impl.BufferUtil;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.image.BufferedImage;
import java.io.File;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import javax.imageio.ImageIO;
import javax.media.opengl.GL2;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLProfile;
import javax.media.opengl.awt.GLCanvas;
import javax.media.opengl.glu.GLU;
import javax.swing.JFrame;
import maprenderer.PMS_Map;
import maprenderer.PMS_Polygon;
import maprenderer.PMS_Vertex;
import thadmin.SoldatPlayer;

public class SolTV {
    private SoldatPlayer[] players = new SoldatPlayer[32];
    private GLCanvas canvas = null;
    private Animator animator;
    private JFrame frame;

    private static boolean changeTexture(String filepath, GL2 gl2) {
        int[] texlist = new int[1];
        gl2.glGenTextures(1, texlist, 0);
        gl2.glBindTexture(3553, 0);
        boolean doTextures = true;
        try {
            BufferedImage image = ImageIO.read(new File(filepath));
            int[] pixels = new int[image.getWidth() * image.getHeight()];
            image.getRGB(0, 0, image.getWidth(), image.getHeight(), pixels, 0, image.getWidth());
            ByteBuffer buffer = BufferUtil.newByteBuffer((int)(image.getWidth() * image.getHeight() * 4));
            for (int y = 0; y < image.getHeight(); ++y) {
                for (int x = 0; x < image.getWidth(); ++x) {
                    int pixel = pixels[y * image.getWidth() + x];
                    buffer.put((byte)(pixel >> 16 & 0xFF));
                    buffer.put((byte)(pixel >> 8 & 0xFF));
                    buffer.put((byte)(pixel & 0xFF));
                    buffer.put((byte)(pixel >> 24 & 0xFF));
                }
            }
            buffer.flip();
            gl2.glTexImage2D(3553, 0, 6408, image.getWidth(), image.getHeight(), 0, 6408, 5121, (Buffer)buffer);
            gl2.glTexParameterf(3553, 10241, 9729.0f);
            gl2.glTexParameterf(3553, 10241, 9729.0f);
        }
        catch (Exception e) {
            e.printStackTrace();
            doTextures = false;
        }
        return doTextures;
    }

    public void setPlayers(SoldatPlayer[] players) {
        this.players = players;
    }

    public void addSamplePlayers() {
    }

    public void render(String mapName) {
        String soldatDir = "/Users/joe/Downloads/yarr";
        String mapPath = "/Users/joe/Downloads/yarr/maps/" + mapName + ".pms";
        final PMS_Map map = new PMS_Map(new File(mapPath));
        final String texturepath = "/Users/joe/Downloads/yarr/textures/" + map.getTexture();
        final int topoffs = map.getSectorDivision() * map.getSectorCount();
        final int bottomoffs = map.getSectorDivision() * -map.getSectorCount();
        final int rightoffs = map.getSectorDivision() * map.getSectorCount();
        final int leftoffs = map.getSectorDivision() * -map.getSectorCount();
        double sfactor = 1.0;
        GLProfile glprofile = GLProfile.getDefault();
        GLCapabilities glcapabilities = new GLCapabilities(glprofile);
        this.canvas = new GLCanvas((GLCapabilitiesImmutable)glcapabilities);
        this.canvas.addGLEventListener(new GLEventListener(){

            public void reshape(GLAutoDrawable glautodrawable, int x, int y, int width, int height) {
            }

            public void init(GLAutoDrawable glautodrawable) {
            }

            public void dispose(GLAutoDrawable glautodrawable) {
            }

            public void display(GLAutoDrawable glautodrawable) {
                GLU glu = new GLU();
                GL2 gl2 = glautodrawable.getGL().getGL2();
                gl2.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
                gl2.glColor3f(0.0f, 0.0f, 1.0f);
                gl2.glMatrixMode(5888);
                gl2.glLoadIdentity();
                glu.gluOrtho2D((float)leftoffs, (float)rightoffs, (float)(-bottomoffs), (float)(-topoffs));
                gl2.glEnable(3042);
                gl2.glEnable(3553);
                gl2.glBlendFunc(770, 771);
                gl2.glClear(16384);
                gl2.glDisable(3553);
                gl2.glBegin(9);
                gl2.glColor4f((float)((double)map.getTopColor().getR() / 255.0), (float)((double)map.getTopColor().getG() / 255.0), (float)((double)map.getTopColor().getB() / 255.0), (float)((double)map.getTopColor().getA() / 255.0));
                gl2.glVertex2f((float)leftoffs, (float)(-topoffs));
                gl2.glVertex2f((float)rightoffs, (float)(-topoffs));
                gl2.glColor4f((float)((double)map.getBottomColor().getR() / 255.0), (float)((double)map.getBottomColor().getG() / 255.0), (float)((double)map.getBottomColor().getB() / 255.0), (float)((double)map.getBottomColor().getA() / 255.0));
                gl2.glVertex2f((float)rightoffs, (float)(-bottomoffs));
                gl2.glVertex2f((float)leftoffs, (float)(-bottomoffs));
                gl2.glEnd();
                gl2.glEnable(3553);
                boolean doTextures = SolTV.changeTexture(texturepath, gl2);
                gl2.glBegin(4);
                for (PMS_Polygon poly : map.getAllPolys()) {
                    for (PMS_Vertex vert : poly.getVertexes()) {
                        gl2.glColor4f((float)((double)vert.getColor().getR() / 255.0), (float)((double)vert.getColor().getG() / 255.0), (float)((double)vert.getColor().getB() / 255.0), (float)((double)vert.getColor().getA() / 255.0));
                        if (doTextures) {
                            gl2.glTexCoord3f(vert.getTU(), -vert.getTV(), 1.0f / vert.getRHW());
                        }
                        gl2.glVertex3f(vert.getX(), vert.getY(), vert.getZ());
                    }
                }
                gl2.glEnd();
                for (SoldatPlayer player : SolTV.this.players) {
                    if (player == null || player.name.equals("")) continue;
                    String iconPath = "/Users/joe/Downloads/yarr/icon_player.png";
                    gl2.glPushMatrix();
                    gl2.glTranslatef((float)player.x, (float)player.y, 0.0f);
                    int width = 14;
                    int height = 24;
                    if (SolTV.changeTexture(iconPath, gl2)) {
                        gl2.glBegin(7);
                        gl2.glTexCoord2f(0.0f, 0.0f);
                        gl2.glVertex2f(0.0f, 0.0f);
                        gl2.glTexCoord2f(1.0f, 0.0f);
                        gl2.glVertex2f((float)width, 0.0f);
                        gl2.glTexCoord2f(1.0f, 1.0f);
                        gl2.glVertex2f((float)width, (float)height);
                        gl2.glTexCoord2f(0.0f, 1.0f);
                        gl2.glVertex2f(0.0f, (float)height);
                        gl2.glEnd();
                    } else {
                        System.out.println("Skipping " + iconPath);
                    }
                    gl2.glPopMatrix();
                }
                gl2.glLoadIdentity();
                glu.gluOrtho2D((double)leftoffs * 1.0, (double)rightoffs * 1.0, (double)topoffs * 1.0, (double)bottomoffs * 1.0);
                gl2.glTranslatef(0.0f, 0.0f, 0.0f);
                gl2.glFlush();
            }
        });
        this.animator = new Animator((GLAutoDrawable)this.canvas);
        this.animator.start();
        this.frame = new JFrame(map.getTitle());
        this.frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowevent) {
                System.out.println("closing?");
                SolTV.this.frame.dispose();
                System.exit(0);
            }
        });
        this.frame.getContentPane().add((Component)this.canvas, "Center");
        this.frame.setSize(640, 480);
        this.frame.setVisible(true);
    }

    public void kill() {
        this.animator.stop();
        this.canvas.destroy();
        this.frame.removeAll();
        this.frame.dispose();
    }
}

