/*
 * Decompiled with CFR 0.152.
 */
package thadmin;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import javax.swing.SwingWorker;
import thadmin.FavoriteServer;
import thadmin.KagServer;
import thadmin.ServerInstance;
import thadmin.ServerType;
import thadmin.SoldatNotif;
import thadmin.SoldatPlayer;
import thadmin.SoldatRegexes;
import thadmin.TabBody;

public class SoldatServer
extends SwingWorker<Void, SoldatNotif>
implements ServerInstance {
    private static final int refreshSize = 1188;
    private Socket Sock = null;
    private BufferedReader In = null;
    private DataOutputStream Out = null;
    private TabBody Window;
    private String Host;
    private String Password;
    private Integer Port;
    public Boolean Connected = false;
    private String ServerVersion = null;
    public static final String[] gameModeIdToString = new String[]{"Deathmatch", "Pointmatch", "Team Deathmatch", "Capture the Flag", "Rambomatch", "Infiltration", "Hold the Flag"};
    public static final String[] teamIdToString = new String[]{"None", "Alpha", "Bravo", "Charlie", "Delta", "Spectator"};
    public static final Color[] teamIdToColor = new Color[]{Color.DARK_GRAY, Color.RED, Color.BLUE, Color.YELLOW, Color.GREEN, Color.GRAY};

    @Override
    public void Connect() {
        System.out.println(String.format("Connecting to %s:%d with %s", this.Host, this.Port, this.Password));
        this.Connected = false;
        try {
            this.Sock = new Socket(this.Host, (int)this.Port);
            this.In = new BufferedReader(new InputStreamReader(this.Sock.getInputStream(), "ISO-8859-1"));
            this.Out = new DataOutputStream(this.Sock.getOutputStream());
            this.Out.writeBytes(this.Password + "\n");
        }
        catch (IOException e) {
            this.Connected = false;
        }
    }

    @Override
    public void sendCommand(String line) {
        if (!this.Connected.booleanValue()) {
            System.out.println("Cannot write if we're not connected");
            return;
        }
        try {
            this.Out.writeBytes(line + "\n");
            System.out.println("wrote " + line);
        }
        catch (IOException e) {
            System.out.println("Failed writing");
        }
    }

    @Override
    public void setDetails(String Host, String Password, Integer Port) {
        this.Host = Host;
        this.Password = Password;
        this.Port = Port;
    }

    @Override
    public void setWindow(TabBody Window2) {
        this.Window = Window2;
    }

    @Override
    public void Disconnect() {
        System.out.println("Disconnecting");
        try {
            this.Sock.close();
            this.In.close();
            this.Out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.Connected = false;
        this.publish(SoldatNotif.eventFactory("Disconnected"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Void doInBackground() throws Exception {
        System.out.println("in background");
        if (this.Connected.booleanValue()) {
            System.out.println("Already connected?");
            return null;
        }
        this.Connect();
        char[] refresh = new char[1188];
        char[] refreshx = new char[1992];
        try {
            int i = 0;
            while (true) {
                if (Thread.interrupted()) {
                    System.out.println("got interrupt");
                    throw new InterruptedException();
                }
                if (i % 25 == 0) {
                    System.out.println("Sending REFRESHX to see if writing fails which means we're disconnected");
                    this.Out.writeBytes("REFRESHX\n");
                    this.Out.flush();
                }
                if (!this.In.ready()) {
                    Thread.sleep(100L);
                } else {
                    String line = this.In.readLine();
                    if (line == null) {
                        break;
                    }
                    if (line.equals("REFRESH")) {
                        System.out.println("I am expecting refresh packet...");
                        try {
                            System.out.println("Got bytes for refresh: " + this.In.read(refresh, 0, 1188));
                            this.parseRefresh(refresh);
                        }
                        catch (IOException e) {
                            System.out.println("failed refresh: " + e);
                        }
                    } else if (line.equals("REFRESHX")) {
                        System.out.println("I am expecting refreshx packet...");
                        try {
                            int j;
                            int recv;
                            for (j = 0; j <= 1992 && (recv = this.In.read(refreshx, j, 1992 - j)) >= 1; j += recv) {
                                System.out.println("Got bytes" + recv);
                            }
                            System.out.println("Got bytes for refreshx: " + j);
                            this.parseRefreshX(refreshx);
                        }
                        catch (Exception e) {
                            System.out.println("issue with refreshx:");
                            e.printStackTrace();
                        }
                    } else {
                        Matcher match;
                        System.out.println("not expecting refresh");
                        if (!this.Connected.booleanValue()) {
                            this.Connected = true;
                            this.publish(SoldatNotif.eventFactory("Connected"));
                        }
                        if (this.ServerVersion == null && (match = SoldatRegexes.lineServerVersion.matcher(line)) != null && match.find()) {
                            this.ServerVersion = match.group(1);
                        }
                        System.out.println("Received line via while: '" + line + "'");
                        line = line.trim();
                        this.publish(SoldatNotif.lineFactory(line));
                    }
                }
                ++i;
            }
        }
        catch (IOException e) {
            System.out.println("Io socket exception: " + e);
        }
        catch (InterruptedException e) {
            System.out.println("Disconnecting via interrupt");
        }
        catch (Exception e) {
            System.out.println("caught something else: " + e);
            e.printStackTrace();
        }
        finally {
            this.Disconnect();
        }
        return null;
    }

    @Override
    protected void process(List<SoldatNotif> messages) {
        for (SoldatNotif notif : messages) {
            if (notif.Type.equals("line")) {
                System.out.println("Recieved line via process: " + notif.Line);
                this.Window.addConsoleLine(notif.Line, "console");
                continue;
            }
            if (notif.Type.equals("event") && notif.Event.equals("Disconnected")) {
                this.Window.onDisconnect();
                continue;
            }
            if (!notif.Type.equals("event") || !notif.Event.equals("Connected")) continue;
            this.Window.onConnect();
        }
    }

    private void parseRefresh(char[] refresh) {
        int j;
        int i;
        int pos = 0;
        SoldatPlayer[] players = new SoldatPlayer[32];
        long[] teamscore = new long[4];
        String mapname = "";
        long timelimit = 0L;
        long currenttime = 0L;
        long killlimit = 0L;
        for (i = 0; i < 32; ++i) {
            players[i] = new SoldatPlayer();
            int length = refresh[pos];
            ++pos;
            for (j = 0; j < length; ++j) {
                players[i].name = players[i].name + refresh[pos];
                ++pos;
            }
            pos += 24 - length;
        }
        for (i = 0; i < 32; ++i) {
            players[i].team = refresh[pos];
            ++pos;
        }
        for (i = 0; i < 32; ++i) {
            players[i].kills = refresh[pos] + refresh[pos + 1] * 256;
            pos += 2;
        }
        for (i = 0; i < 32; ++i) {
            players[i].deaths = refresh[pos] + refresh[pos + 1] * 256;
            pos += 2;
        }
        for (i = 0; i < 32; ++i) {
            players[i].ping = refresh[pos];
            ++pos;
        }
        for (i = 0; i < 32; ++i) {
            players[i].id = refresh[pos];
            ++pos;
        }
        for (i = 0; i < 32; ++i) {
            int[] ips = new int[4];
            for (j = 0; j < 4; ++j) {
                ips[j] = refresh[pos];
                ++pos;
            }
            players[i].ip = ips[0] + "." + ips[1] + "." + ips[2] + "." + ips[3];
        }
        for (i = 0; i < 4; ++i) {
            teamscore[i] = refresh[pos] + refresh[pos + 1] * 256;
            pos += 2;
        }
        int maplength = refresh[pos];
        ++pos;
        for (i = 0; i < maplength; ++i) {
            mapname = mapname + refresh[pos];
            ++pos;
        }
        pos += 16 - maplength;
        for (i = 0; i < 4; ++i) {
            timelimit += (long)(refresh[pos] * (0x100 ^ i));
            ++pos;
        }
        for (i = 0; i < 4; ++i) {
            currenttime += (long)(refresh[pos] * (0x100 ^ i));
            ++pos;
        }
        killlimit = refresh[pos] + refresh[pos + 1];
        char gametype = refresh[pos += 2];
        this.Window.drawSoldatPlayers(players);
        this.Window.updateSoldatGameInfo(mapname, "", gameModeIdToString[gametype], timelimit - currenttime, this.ServerVersion);
    }

    private void parseRefreshX(char[] refreshx) {
        int j;
        int i;
        ByteBuffer buff = ByteBuffer.allocate(refreshx.length + 1);
        buff.order(ByteOrder.LITTLE_ENDIAN);
        for (i = 0; i < refreshx.length; ++i) {
            buff.put((byte)refreshx[i]);
        }
        SoldatPlayer[] players = new SoldatPlayer[32];
        String map = "";
        String nextMap = "";
        int[] teamscore = new int[4];
        int pos = 0;
        for (i = 0; i < 32; ++i) {
            players[i] = new SoldatPlayer();
            int length = refreshx[pos];
            ++pos;
            for (j = 0; j < length; ++j) {
                players[i].name = players[i].name + refreshx[pos];
                ++pos;
            }
            pos += 24 - length;
        }
        for (i = 0; i < 32; ++i) {
            for (j = 0; j < 12; ++j) {
                players[i].hwid = players[i].hwid + refreshx[pos];
                ++pos;
            }
        }
        for (i = 0; i < 32; ++i) {
            players[i].team = refreshx[pos];
            ++pos;
        }
        for (i = 0; i < 32; ++i) {
            players[i].kills = buff.getShort(pos);
            pos += 2;
        }
        for (i = 0; i < 32; ++i) {
            players[i].caps = refreshx[pos];
            ++pos;
        }
        for (i = 0; i < 32; ++i) {
            players[i].deaths = buff.getShort(pos);
            pos += 2;
        }
        for (i = 0; i < 32; ++i) {
            players[i].ping = buff.getInt(pos);
            pos += 4;
        }
        for (i = 0; i < 32; ++i) {
            players[i].id = refreshx[pos];
            ++pos;
        }
        for (i = 0; i < 32; ++i) {
            int[] ips = new int[4];
            for (j = 0; j < 4; ++j) {
                ips[j] = refreshx[pos];
                ++pos;
            }
            players[i].ip = ips[0] + "." + ips[1] + "." + ips[2] + "." + ips[3];
        }
        for (i = 0; i < 32; ++i) {
            players[i].x = buff.getFloat(pos);
            pos += 4;
        }
        for (i = 0; i < 32; ++i) {
            players[i].y = buff.getFloat(pos);
            pos += 4;
        }
        double redflagx = buff.getFloat(pos);
        double redflagy = buff.getFloat(pos += 4);
        double blueflagx = buff.getFloat(pos += 4);
        double blueflagy = buff.getFloat(pos += 4);
        pos += 4;
        for (i = 0; i < 4; ++i) {
            teamscore[i] = refreshx[pos] + refreshx[pos + 1] * 256;
            pos += 2;
        }
        j = refreshx[pos];
        System.out.println("map length: " + j);
        ++pos;
        for (i = 0; i < j; ++i) {
            map = map + refreshx[pos];
            ++pos;
        }
        long timeLimit = buff.getInt(pos += 16 - j);
        long currentTime = buff.getInt(pos += 4);
        System.out.println("Time: " + currentTime + "/" + timeLimit);
        short killLimit = buff.getShort(pos += 4);
        char gameType = refreshx[pos += 2];
        char maxPlayers = refreshx[++pos];
        char maxSpectators = refreshx[++pos];
        boolean passworded = refreshx[++pos] == '\u0001';
        System.out.println("Gametype: " + gameType);
        System.out.println("max players: " + maxPlayers);
        System.out.println("passworded: " + (passworded ? "Yes" : "no"));
        j = refreshx[++pos];
        ++pos;
        for (i = 0; i < j; ++i) {
            nextMap = nextMap + refreshx[pos];
            ++pos;
        }
        for (SoldatPlayer player : players) {
            if (player.name.equals("")) continue;
            System.out.println("Player: " + player.name + " hwid: " + player.hwid + " team: " + player.team + " kills: " + player.kills + " deaths: " + player.deaths + " ping: " + player.ping + " x:" + player.x + " y: " + player.y);
        }
        System.out.println("Current map: '" + map + "' next map: '" + nextMap + "'");
        this.Window.drawSoldatPlayers(players);
        this.Window.updateSoldatGameInfo(map, nextMap, gameModeIdToString[gameType], timeLimit - currentTime, this.ServerVersion);
    }

    @Override
    public void kickPlayer(int id) {
        if (!this.Connected.booleanValue()) {
            return;
        }
        System.out.println("Will kick player ID " + id);
        try {
            this.Out.writeBytes("/kick " + id + "\n");
        }
        catch (IOException ex) {
            Logger.getLogger(KagServer.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void banPlayer(int id) {
        if (!this.Connected.booleanValue()) {
            return;
        }
        System.out.println("Will ban player ID " + id);
        try {
            this.Out.writeBytes("/ban " + id + "\n");
        }
        catch (IOException ex) {
            Logger.getLogger(KagServer.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public FavoriteServer getFavServer() {
        FavoriteServer fav = new FavoriteServer();
        fav.Ip = this.Host;
        fav.Port = this.Port;
        fav.Password = this.Password;
        fav.Type = ServerType.SOLDAT;
        return fav;
    }
}

