/*
 * Decompiled with CFR 0.152.
 */
package thadmin;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import pmsrenderer.SolTV;
import thadmin.ColorString;
import thadmin.Conf;
import thadmin.FavoriteServer;
import thadmin.FavoriteServers;
import thadmin.IconString;
import thadmin.Icons;
import thadmin.KagPlayer;
import thadmin.KagRegexes;
import thadmin.KagServer;
import thadmin.MainWindow;
import thadmin.PlayerContextMenu;
import thadmin.ServerInstance;
import thadmin.ServerType;
import thadmin.SoldatPlayer;
import thadmin.SoldatRegexes;
import thadmin.SoldatServer;

public class TabBody
extends JPanel {
    private ServerInstance Server = null;
    private boolean Connected = false;
    private DefaultTableModel PlayerModel = null;
    private ServerType type;
    private String hostString = "";
    private MainWindow tabController;
    private SolTV soltv;
    private String currentMap = "";
    private JPanel BottomInfoPanel;
    private JTextField CommandBox;
    private JButton CommandButton;
    private JButton ConnectButton;
    private JTextPane ConsoleLog;
    private JScrollPane ConsoleLogPane;
    private JButton FavoriteToggleButton;
    private JLabel GameTypeLabel;
    private JTextField HostBox;
    private JLabel MapNameLabel;
    private JPasswordField PasswordBox;
    private JTable PlayerTable;
    private JButton ShowTvButton;
    private JLabel VersionLabel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JSplitPane jSplitPane1;

    public TabBody(ServerType type, MainWindow tabController) {
        class Coloredrenderer
        extends DefaultTableCellRenderer {
            Coloredrenderer() {
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component elem = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (value instanceof ColorString) {
                    ColorString info = (ColorString)value;
                    if (!isSelected) {
                        elem.setForeground(info.color);
                    }
                    this.setText(info.string);
                } else if (value instanceof IconString) {
                    IconString info = (IconString)value;
                    this.setIcon(info.icon);
                    this.setText(info.string);
                }
                return elem;
            }
        }
        this.type = type;
        this.tabController = tabController;
        this.initComponents();
        this.BottomInfoPanel.setVisible(false);
        if (type != ServerType.SOLDAT) {
            this.ShowTvButton.setVisible(false);
        }
        DefaultCaret caret = (DefaultCaret)this.ConsoleLog.getCaret();
        caret.setUpdatePolicy(2);
        if (type == ServerType.KAG) {
            this.PlayerModel = new DefaultTableModel(new Object[0][], new String[]{"ID", "Player", "IP", "HWID"}){

                public Class getColumnClass(int columnIndex) {
                    return this.getValueAt(0, columnIndex).getClass();
                }

                @Override
                public boolean isCellEditable(int rowIndex, int columnIndex) {
                    return false;
                }
            };
        } else if (type == ServerType.SOLDAT) {
            this.PlayerModel = new DefaultTableModel(new Object[0][], new String[]{"ID", "Player", "Team", "Kills", "Deaths", "HWID", "IP", "Ping"}){

                public Class getColumnClass(int columnIndex) {
                    return this.getValueAt(0, columnIndex).getClass();
                }

                @Override
                public boolean isCellEditable(int rowIndex, int columnIndex) {
                    return false;
                }
            };
        }
        this.PlayerTable.setModel(this.PlayerModel);
        this.PlayerTable.setBackground(Color.white);
        if (type == ServerType.SOLDAT) {
            this.PlayerTable.getColumnModel().getColumn(1).setCellRenderer(new Coloredrenderer());
            this.PlayerTable.getColumnModel().getColumn(2).setCellRenderer(new Coloredrenderer());
            this.PlayerTable.getColumnModel().getColumn(7).setCellRenderer(new Coloredrenderer());
            this.PlayerTable.getColumnModel().getColumn(0).setMaxWidth(50);
        } else if (type == ServerType.KAG) {
            this.PlayerTable.getColumnModel().getColumn(1).setCellRenderer(new Coloredrenderer());
            this.PlayerTable.getColumnModel().getColumn(0).setMaxWidth(50);
        }
        this.ShowTvButton.setEnabled(false);
        this.ShowTvButton.setVisible(false);
        this.FavoriteToggleButton.setVisible(true);
        this.FavoriteToggleButton.setEnabled(false);
    }

    public void SetServerAndJoin(String Ip, int Port, String Password) {
        this.HostBox.setText(Ip + ":" + Port);
        this.PasswordBox.setText(Password);
        this.ConnectButton.doClick();
    }

    public ServerType getType() {
        return this.type;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.HostBox = new JTextField();
        this.jLabel2 = new JLabel();
        this.PasswordBox = new JPasswordField();
        this.ConnectButton = new JButton();
        this.CommandBox = new JTextField();
        this.CommandButton = new JButton();
        this.jSplitPane1 = new JSplitPane();
        this.ConsoleLogPane = new JScrollPane();
        this.ConsoleLog = new JTextPane();
        this.jScrollPane1 = new JScrollPane();
        this.PlayerTable = new JTable();
        this.BottomInfoPanel = new JPanel();
        this.GameTypeLabel = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.MapNameLabel = new JLabel();
        this.VersionLabel = new JLabel();
        this.ShowTvButton = new JButton();
        this.FavoriteToggleButton = new JButton();
        this.jLabel1.setText("IP:port");
        this.HostBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TabBody.this.HostBoxActionPerformed(evt);
            }
        });
        this.jLabel2.setText("Password:");
        this.ConnectButton.setText("Connect");
        this.ConnectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TabBody.this.ConnectButtonActionPerformed(evt);
            }
        });
        this.CommandBox.setEditable(false);
        this.CommandBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TabBody.this.CommandBoxActionPerformed(evt);
            }
        });
        this.CommandButton.setText("Run");
        this.CommandButton.setEnabled(false);
        this.CommandButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TabBody.this.CommandButtonActionPerformed(evt);
            }
        });
        this.jSplitPane1.setOrientation(0);
        this.ConsoleLog.setEditable(false);
        this.ConsoleLog.setMinimumSize(new Dimension(0, 100));
        this.ConsoleLog.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                TabBody.this.ConsoleLogMouseClicked(evt);
            }
        });
        this.ConsoleLogPane.setViewportView(this.ConsoleLog);
        this.jSplitPane1.setBottomComponent(this.ConsoleLogPane);
        this.jScrollPane1.setMinimumSize(new Dimension(23, 100));
        this.PlayerTable.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.PlayerTable.setShowGrid(false);
        this.PlayerTable.setSurrendersFocusOnKeystroke(true);
        this.PlayerTable.getTableHeader().setReorderingAllowed(false);
        this.PlayerTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                TabBody.this.PlayerTableMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.PlayerTable);
        this.jSplitPane1.setLeftComponent(this.jScrollPane1);
        this.GameTypeLabel.setText("GameType");
        this.jSeparator1.setOrientation(1);
        this.MapNameLabel.setText("Map");
        this.VersionLabel.setText("Version");
        GroupLayout BottomInfoPanelLayout = new GroupLayout(this.BottomInfoPanel);
        this.BottomInfoPanel.setLayout(BottomInfoPanelLayout);
        BottomInfoPanelLayout.setHorizontalGroup(BottomInfoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(BottomInfoPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.GameTypeLabel, -2, 71, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.MapNameLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.VersionLabel).addContainerGap()));
        BottomInfoPanelLayout.setVerticalGroup(BottomInfoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(BottomInfoPanelLayout.createSequentialGroup().addContainerGap().addGroup(BottomInfoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jSeparator1).addComponent(this.GameTypeLabel, -1, -1, Short.MAX_VALUE).addGroup(BottomInfoPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.MapNameLabel, -1, -1, Short.MAX_VALUE).addComponent(this.VersionLabel))).addContainerGap(-1, Short.MAX_VALUE)));
        this.ShowTvButton.setText("Show TV");
        this.ShowTvButton.setEnabled(false);
        this.ShowTvButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                TabBody.this.ShowTvButtonMouseClicked(evt);
            }
        });
        this.ShowTvButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TabBody.this.ShowTvButtonActionPerformed(evt);
            }
        });
        this.FavoriteToggleButton.setText("Add Favorite");
        this.FavoriteToggleButton.setEnabled(false);
        this.FavoriteToggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TabBody.this.FavoriteToggleButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.BottomInfoPanel, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane1).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.HostBox, -2, 237, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.PasswordBox, -2, 122, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ConnectButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.FavoriteToggleButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ShowTvButton)).addGroup(layout.createSequentialGroup().addComponent(this.CommandBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.CommandButton))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.HostBox, -2, -1, -2).addComponent(this.jLabel1).addComponent(this.jLabel2).addComponent(this.PasswordBox, -2, -1, -2).addComponent(this.ConnectButton).addComponent(this.ShowTvButton).addComponent(this.FavoriteToggleButton)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSplitPane1, -1, 391, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.CommandBox, -2, 30, -2).addComponent(this.CommandButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.BottomInfoPanel, -2, 24, -2)));
    }

    private void HostBoxActionPerformed(ActionEvent evt) {
    }

    private void CommandBoxActionPerformed(ActionEvent evt) {
    }

    private void ConnectButtonActionPerformed(ActionEvent evt) {
        if (this.ConnectButton.getText().equals("Disconnect")) {
            this.HandleDisonnect();
        } else if (this.ConnectButton.getText().equals("Connect")) {
            System.out.println("clicked connect");
            this.HandleConnect();
        }
    }

    private void SendCommand() {
        String command = this.CommandBox.getText().trim();
        this.CommandBox.setText("");
        if (command.length() == 0 || !this.Connected || this.Server == null) {
            return;
        }
        this.Server.sendCommand(command);
    }

    public boolean isConnected() {
        return this.Connected;
    }

    private void CommandButtonActionPerformed(ActionEvent evt) {
        this.SendCommand();
    }

    private void ShowTvButtonActionPerformed(ActionEvent evt) {
        if (!this.Connected) {
            System.out.println("Not connected. Killing.");
            this.killSolTv();
            return;
        }
        if (this.soltv != null) {
            System.out.println("Not null. Killing.");
            this.killSolTv();
            return;
        }
        System.out.println("Creating SolTV Object");
        this.soltv = new SolTV();
        if (!this.currentMap.equals("")) {
            System.out.println("Beginning rneder");
            this.soltv.render(this.currentMap);
            this.ShowTvButton.setText("Close TV");
        }
    }

    private void ShowTvButtonMouseClicked(MouseEvent evt) {
    }

    private void ConsoleLogMouseClicked(MouseEvent evt) {
    }

    private void PlayerTableMouseClicked(MouseEvent evt) {
        if (!this.Connected) {
            return;
        }
        if (!SwingUtilities.isRightMouseButton(evt)) {
            return;
        }
        int row = this.PlayerTable.rowAtPoint(evt.getPoint());
        IconString icon = (IconString)this.PlayerTable.getModel().getValueAt(row, 1);
        PlayerContextMenu menu = new PlayerContextMenu(this.Server, icon.Player, icon.Id);
        menu.show(evt.getComponent(), evt.getX(), evt.getY());
    }

    private void FavoriteToggleButtonActionPerformed(ActionEvent evt) {
        if (!this.Connected || this.Server == null) {
            return;
        }
        FavoriteServer fav = this.Server.getFavServer();
        if (FavoriteServers.CheckInFavorites(fav)) {
            FavoriteServers.DelFromFavorites(fav);
        } else {
            FavoriteServers.AddToFavorites(fav);
        }
        FavoriteServers.Save();
        this.ManageFavoriteToggleText(fav);
    }

    private void ManageFavoriteToggleText(FavoriteServer fav) {
        if (FavoriteServers.CheckInFavorites(null == fav ? this.Server.getFavServer() : fav)) {
            this.FavoriteToggleButton.setText("Un-Favorite");
        } else {
            this.FavoriteToggleButton.setText("Add Favorite");
        }
    }

    private void killSolTv() {
        if (this.soltv != null) {
            this.soltv.kill();
            this.soltv = null;
        }
        this.ShowTvButton.setText("Show TV");
    }

    private void PasswordBoxKeyTyped(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.HandleConnect();
        }
    }

    private void CommandBoxKeyTyped(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.HandleConnect();
        }
    }

    private void HandleConnect() {
        Integer Port;
        String IpPort = this.HostBox.getText().trim();
        String Password = new String(this.PasswordBox.getPassword());
        String[] parts = IpPort.split(":");
        if (parts.length < 2 || IpPort.length() == 0 || Password.length() == 0) {
            JOptionPane.showMessageDialog(this, "You must appropriately fill out the password fields", "Incomplete input", 0);
            return;
        }
        String Host = parts[0];
        try {
            Port = Integer.parseInt(parts[1]);
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(this, "Port does not look like a number", "Incomplete input", 0);
            return;
        }
        if (Port < 1 || Port > 65000) {
            JOptionPane.showMessageDialog(this, "Port is not within a realistic range", "Incomplete input", 0);
            return;
        }
        System.out.println("passed checks");
        this.ConnectButton.setEnabled(false);
        this.hostString = IpPort;
        if (this.type == ServerType.KAG) {
            this.Server = new KagServer();
        } else if (this.type == ServerType.SOLDAT) {
            this.Server = new SoldatServer();
        } else {
            return;
        }
        this.Server.setWindow(this);
        this.Server.setDetails(Host, Password, Port);
        this.Server.execute();
        this.tabController.fixTabs();
    }

    public String getHostString() {
        return this.hostString;
    }

    public void HandleDisonnect() {
        if (this.Server == null) {
            return;
        }
        boolean success = this.Server.cancel(true);
        if (success) {
            System.out.println("Cancelled worker");
        } else {
            System.out.println("Failed to cancel worker");
        }
        this.killSolTv();
    }

    public void addConsoleLine(String line, String type) {
        Matcher match;
        SimpleAttributeSet style;
        this.tabController.fixTabs();
        StyledDocument doc = this.ConsoleLog.getStyledDocument();
        StyleContext context = new StyleContext();
        class StyledText {
            SimpleAttributeSet style;
            String text;
            Style styleS;

            public StyledText(SimpleAttributeSet style, String text) {
                this.text = text;
                this.style = style;
            }

            public StyledText(Style style) {
                this.styleS = style;
                this.text = " ";
            }
        }
        ArrayList<StyledText> words = new ArrayList<StyledText>();
        if (type.equals("connect")) {
            style = new SimpleAttributeSet();
            StyleConstants.setForeground(style, Conf.getColor("consolelog.connected"));
            StyleConstants.setBold(style, true);
            words.add(new StyledText(style, line));
        } else if (type.equals("disconnect")) {
            style = new SimpleAttributeSet();
            StyleConstants.setForeground(style, Conf.getColor("consolelog.disconnected"));
            StyleConstants.setBold(style, true);
            words.add(new StyledText(style, line));
        } else if (type.equals("console") && this.type == ServerType.KAG) {
            match = KagRegexes.lineRconConnect.matcher(line);
            if (match != null && match.find()) {
                style = new SimpleAttributeSet();
                StyleConstants.setBold(style, true);
                StyleConstants.setForeground(style, Conf.getColor("consolelog.timestamp"));
                words.add(new StyledText(style, match.group(1)));
                words.add(new StyledText(null, " TCP RCON Connection from "));
                style = new SimpleAttributeSet();
                StyleConstants.setForeground(style, Conf.getColor("kag.rconauthip"));
                StyleConstants.setBold(style, true);
                words.add(new StyledText(style, match.group(2)));
                words.add(new StyledText(null, " is now authenticated"));
            } else {
                match = KagRegexes.linePlayerSpeak.matcher(line);
                if (match != null && match.find()) {
                    style = new SimpleAttributeSet();
                    StyleConstants.setBold(style, true);
                    StyleConstants.setForeground(style, Conf.getColor("consolelog.timestamp"));
                    words.add(new StyledText(style, match.group(1)));
                    words.add(new StyledText(null, " "));
                    style = new SimpleAttributeSet();
                    StyleConstants.setForeground(style, Conf.getColor("kag.playerspeaknick"));
                    StyleConstants.setBold(style, true);
                    words.add(new StyledText(style, match.group(2)));
                    words.add(new StyledText(null, " "));
                    style = new SimpleAttributeSet();
                    StyleConstants.setForeground(style, Conf.getColor("kag.playerspeakmessage"));
                    words.add(new StyledText(style, match.group(3)));
                } else {
                    match = KagRegexes.lineRconCommand.matcher(line);
                    if (match != null && match.find()) {
                        if (match.group(3).equals("/players")) {
                            return;
                        }
                        style = new SimpleAttributeSet();
                        StyleConstants.setBold(style, true);
                        StyleConstants.setForeground(style, Conf.getColor("consolelog.timestamp"));
                        words.add(new StyledText(style, match.group(1)));
                        words.add(new StyledText(null, " RCON command from "));
                        style = new SimpleAttributeSet();
                        StyleConstants.setForeground(style, Conf.getColor("kag.rconcmdsrc"));
                        StyleConstants.setBold(style, true);
                        words.add(new StyledText(style, match.group(2)));
                        words.add(new StyledText(null, ": "));
                        style = new SimpleAttributeSet();
                        StyleConstants.setForeground(style, Conf.getColor("kag.rconcmd"));
                        StyleConstants.setBold(style, true);
                        words.add(new StyledText(style, match.group(3)));
                    } else {
                        match = KagRegexes.lineConsole.matcher(line);
                        if (match != null && match.find()) {
                            if (match.group(2).trim().length() == 0 || match.group(2).equals(" /players")) {
                                return;
                            }
                            style = new SimpleAttributeSet();
                            StyleConstants.setBold(style, true);
                            StyleConstants.setForeground(style, Conf.getColor("consolelog.timestamp"));
                            words.add(new StyledText(style, match.group(1)));
                            words.add(new StyledText(null, " "));
                            style = new SimpleAttributeSet();
                            StyleConstants.setForeground(style, Conf.getColor("consolelog.default"));
                            words.add(new StyledText(style, match.group(2)));
                        }
                    }
                }
            }
        } else if (type.equals("console") && this.type == ServerType.SOLDAT && (match = SoldatRegexes.linePlayerKill.matcher(line)) != null && match.find()) {
            style = new SimpleAttributeSet();
            StyleConstants.setBold(style, true);
            words.add(new StyledText(style, match.group(1)));
            words.add(new StyledText(null, " killed "));
            style = new SimpleAttributeSet();
            StyleConstants.setBold(style, true);
            words.add(new StyledText(style, match.group(2)));
            words.add(new StyledText(null, " with "));
            Icon gunPic = Icons.soldatGunIcon(match.group(3));
            if (gunPic != null) {
                Style gunStyle = context.getStyle("default");
                JLabel gunLabel = new JLabel(gunPic);
                gunLabel.setToolTipText(match.group(3));
                StyleConstants.setComponent(gunStyle, gunLabel);
                words.add(new StyledText(gunStyle));
                words.add(new StyledText(null, "."));
            } else {
                style = new SimpleAttributeSet();
                StyleConstants.setBold(style, true);
                words.add(new StyledText(style, match.group(3)));
            }
        }
        if (words.isEmpty()) {
            style = new SimpleAttributeSet();
            StyleConstants.setForeground(style, Conf.getColor("consolelog.default"));
            words.add(new StyledText(style, line));
        }
        words.add(new StyledText(null, "\n"));
        try {
            for (StyledText text : words) {
                doc.insertString(doc.getLength(), text.text, text.style == null ? text.styleS : text.style);
            }
        }
        catch (BadLocationException e) {
            // empty catch block
        }
    }

    public void onConnect() {
        this.ConnectButton.setText("Disconnect");
        this.HostBox.setEditable(false);
        this.PasswordBox.setEditable(false);
        this.CommandBox.setEditable(true);
        this.CommandButton.setEnabled(true);
        this.Connected = true;
        this.ConnectButton.setEnabled(true);
        this.addConsoleLine("Connected", "connect");
        this.ShowTvButton.setEnabled(false);
        this.ShowTvButton.setVisible(false);
        this.tabController.fixTabs();
        if (this.type == ServerType.SOLDAT) {
            this.BottomInfoPanel.setVisible(true);
            this.ShowTvButton.setText("Show TV");
        }
        if (this.Server != null) {
            this.FavoriteToggleButton.setVisible(true);
            this.FavoriteToggleButton.setEnabled(true);
            this.ManageFavoriteToggleText(null);
        }
    }

    public void onDisconnect() {
        this.ConnectButton.setText("Connect");
        this.HostBox.setEditable(true);
        this.PasswordBox.setEditable(true);
        this.CommandBox.setEditable(false);
        this.CommandBox.setText("");
        this.CommandButton.setEnabled(false);
        this.Connected = false;
        this.ConnectButton.setEnabled(true);
        this.addConsoleLine("Disconnected..", "disconnect");
        this.PlayerModel.setRowCount(0);
        this.tabController.fixTabs();
        this.BottomInfoPanel.setVisible(false);
        this.ShowTvButton.setEnabled(false);
        this.ShowTvButton.setText("Show TV");
        this.FavoriteToggleButton.setEnabled(true);
    }

    public void drawKagPlayers(List<KagPlayer> players) {
        this.PlayerModel.setRowCount(0);
        for (KagPlayer player : players) {
            Icon country = Icons.ipCountryIcon(player.ip);
            IconString playerIcon = new IconString(country == null ? null : country, player.name);
            playerIcon.Player = player.name;
            playerIcon.Id = player.id;
            playerIcon.Type = "PlayerMenu";
            this.PlayerModel.addRow(new Object[]{player.id, playerIcon, player.ip, player.hwid});
        }
    }

    public void drawSoldatPlayers(SoldatPlayer[] players) {
        this.PlayerModel.setRowCount(0);
        for (SoldatPlayer player : players) {
            if (player.name.length() == 0) continue;
            ColorString team = new ColorString();
            team.color = SoldatServer.teamIdToColor[player.team];
            team.string = SoldatServer.teamIdToString[player.team];
            Icon country = Icons.ipCountryIcon(player.ip);
            IconString playerIcon = new IconString(country == null ? null : country, player.name);
            playerIcon.Player = player.name;
            playerIcon.Type = "PlayerMenu";
            playerIcon.Id = player.id;
            this.PlayerModel.addRow(new Object[]{player.id, playerIcon, team, player.kills, player.deaths, player.hwid, player.ip.equals("0.0.0.0") ? "" : player.ip, player.ip.equals("0.0.0.0") ? new IconString(Icons.getBotIcon(), "") : new IconString(null, "" + player.ping)});
        }
        if (this.soltv != null) {
            this.soltv.setPlayers(players);
        }
    }

    public void updateSoldatGameInfo(String map, String nextMap, String gametype, long timeleft, String version) {
        this.GameTypeLabel.setText(gametype);
        this.MapNameLabel.setText(map + " (next: " + nextMap + ")");
        this.VersionLabel.setText(version);
        if (!this.currentMap.equals(map) && this.soltv != null) {
            this.soltv.kill();
            this.soltv.render(map);
        }
        this.currentMap = map;
    }
}

