/*
 * Decompiled with CFR 0.152.
 */
package thadmin;

import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import thadmin.Conf;
import thadmin.FavoriteServers;
import thadmin.Icons;
import thadmin.IpCountry;
import thadmin.ServerType;
import thadmin.TabBody;
import thadmin.TabUtils;

public class MainWindow
extends JFrame {
    ArrayList<TabBody> serverTabs;
    private JTabbedPane Tabs;
    private JButton addKagButton;
    private JButton addSoldatButton;
    private JButton openFavoritesButton;

    public MainWindow() {
        this.initComponents();
        this.openFavoritesButton.setVisible(false);
        this.addKagButton.setIcon(Icons.getIcon(ServerType.KAG));
        this.addSoldatButton.setIcon(Icons.getIcon(ServerType.SOLDAT));
        IpCountry.Load();
        Conf.Load();
        FavoriteServers.Load();
        FavoriteServers.connectServers(this);
    }

    private void initComponents() {
        this.Tabs = new JTabbedPane();
        this.addKagButton = new JButton();
        this.addSoldatButton = new JButton();
        this.openFavoritesButton = new JButton();
        this.setDefaultCloseOperation(3);
        this.setTitle("THD Admin");
        this.setMinimumSize(new Dimension(700, 400));
        this.addKagButton.setText("Add KAG Tab");
        this.addKagButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.addKagButtonActionPerformed(evt);
            }
        });
        this.addSoldatButton.setText("Add Soldat Tab");
        this.addSoldatButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.addSoldatButtonActionPerformed(evt);
            }
        });
        this.openFavoritesButton.setText("Favorites");
        this.openFavoritesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.openFavoritesButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.addKagButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.addSoldatButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 235, Short.MAX_VALUE).addComponent(this.openFavoritesButton).addContainerGap()).addComponent(this.Tabs, GroupLayout.Alignment.TRAILING));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.addKagButton).addComponent(this.addSoldatButton).addComponent(this.openFavoritesButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.Tabs, -1, 353, Short.MAX_VALUE).addContainerGap()));
        this.pack();
    }

    private void addKagButtonActionPerformed(ActionEvent evt) {
        ServerType type = ServerType.KAG;
        TabBody tab = new TabBody(type, this);
        this.Tabs.addTab("Server", tab);
        this.fixTabs();
    }

    private void addSoldatButtonActionPerformed(ActionEvent evt) {
        ServerType type = ServerType.SOLDAT;
        TabBody tab = new TabBody(type, this);
        this.Tabs.addTab("Server", tab);
        this.fixTabs();
    }

    private void openFavoritesButtonActionPerformed(ActionEvent evt) {
    }

    public void addTab(TabBody tab, String title) {
        this.Tabs.addTab(title, tab);
        this.fixTabs();
    }

    public void fixTabs() {
        int tabcount = this.Tabs.getTabCount();
        for (int index = 0; index < tabcount; ++index) {
            TabBody tab = (TabBody)this.Tabs.getComponentAt(index);
            String title = tab.getHostString();
            title = title.length() == 0 ? "Server" : title;
            title = title + (title.equals("Server") ? "" : (tab.isConnected() ? " (Connected)" : " (Disconnected)"));
            this.Tabs.setTabComponentAt(index, TabUtils.getTabLabel(tab.getType(), title, this, tab));
        }
    }

    public void killTab(TabBody component) {
        int tabcount = this.Tabs.getTabCount();
        int tabIndexToKill = -1;
        for (int index = 0; index < tabcount; ++index) {
            if (component != (TabBody)this.Tabs.getComponentAt(index)) continue;
            tabIndexToKill = index;
            break;
        }
        if (tabIndexToKill == -1) {
            System.out.println("wtf couldnt find index");
            return;
        }
        component.HandleDisonnect();
        this.Tabs.removeTabAt(tabIndexToKill);
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(MainWindow.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(MainWindow.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(MainWindow.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(MainWindow.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new MainWindow().setVisible(true);
            }
        });
    }
}

