/*
 * Decompiled with CFR 0.152.
 */
package thadmin;

import javax.swing.Icon;
import javax.swing.ImageIcon;
import thadmin.IpCountry;
import thadmin.ServerType;

public class Icons {
    private static final String kagIconPath = "kag_icon.png";
    private static final String SoldatIconPath = "soldat_icon.png";
    private static final String botIconPath = "bot_icon.png";
    private static ImageIcon kagIcon = null;
    private static ImageIcon soldatIcon = null;
    private static ImageIcon botIcon = null;

    public static Icon getIcon(ServerType type) {
        ImageIcon icon = null;
        try {
            if (type == ServerType.KAG) {
                if (kagIcon == null) {
                    kagIcon = new ImageIcon(ClassLoader.getSystemResource(kagIconPath));
                }
                icon = kagIcon;
            } else if (type == ServerType.SOLDAT) {
                if (soldatIcon == null) {
                    soldatIcon = new ImageIcon(ClassLoader.getSystemResource(SoldatIconPath));
                }
                icon = soldatIcon;
            }
        }
        catch (Exception e) {
            return icon;
        }
        return icon;
    }

    public static Icon getBotIcon() {
        ImageIcon icon = null;
        try {
            if (botIcon == null) {
                botIcon = new ImageIcon(ClassLoader.getSystemResource(botIconPath));
            }
            icon = botIcon;
        }
        catch (Exception e) {
            return icon;
        }
        return icon;
    }

    public static Icon ipCountryIcon(String ip) {
        ImageIcon icon;
        String code = IpCountry.lookup(ip);
        String path = "res/flags/" + code.toLowerCase() + ".png";
        try {
            icon = new ImageIcon(path);
        }
        catch (Exception e) {
            System.out.println("Failed getting icon: " + e);
            return null;
        }
        return icon;
    }

    public static Icon soldatGunIcon(String gun) {
        ImageIcon icon;
        String path = "res/soldatguns/" + gun.replace(" ", "_") + ".png";
        try {
            icon = new ImageIcon(path);
        }
        catch (Exception e) {
            System.out.println("Failed getting icon: " + e);
            return null;
        }
        return icon;
    }
}

