/*
 * Decompiled with CFR 0.152.
 */
package thadmin;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import javax.swing.SwingWorker;
import thadmin.FavoriteServer;
import thadmin.KagNotif;
import thadmin.KagPlayer;
import thadmin.KagRegexes;
import thadmin.ServerInstance;
import thadmin.ServerType;
import thadmin.TabBody;

public class KagServer
extends SwingWorker<Void, KagNotif>
implements ServerInstance {
    private Socket Sock = null;
    private BufferedReader In = null;
    private DataOutputStream Out = null;
    private TabBody Window;
    private String Host;
    private String Password;
    private Integer Port;
    public Boolean Connected = false;

    @Override
    public void setWindow(TabBody Window2) {
        this.Window = Window2;
    }

    @Override
    public void setDetails(String Host, String Password, Integer Port) {
        this.Host = Host;
        this.Password = Password;
        this.Port = Port;
    }

    @Override
    public void Connect() {
        System.out.println(String.format("Connecting to %s:%d with %s", this.Host, this.Port, this.Password));
        this.Connected = false;
        try {
            this.Sock = new Socket(this.Host, (int)this.Port);
            this.In = new BufferedReader(new InputStreamReader(this.Sock.getInputStream(), "ISO-8859-1"));
            this.Out = new DataOutputStream(this.Sock.getOutputStream());
            this.Out.writeBytes(this.Password + "\n");
        }
        catch (IOException e) {
            this.Connected = false;
        }
    }

    @Override
    public void Disconnect() {
        System.out.println("Disconnecting");
        try {
            this.Sock.close();
            this.In.close();
            this.Out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.Connected = false;
        this.publish(KagNotif.eventFactory("Disconnected"));
    }

    @Override
    public void sendCommand(String line) {
        if (!this.Connected.booleanValue()) {
            System.out.println("Cannot write if we're not connected");
            return;
        }
        try {
            this.Out.writeBytes(line + "\n");
        }
        catch (IOException e) {
            System.out.println("Failed writing");
        }
    }

    @Override
    public void kickPlayer(int id) {
        if (!this.Connected.booleanValue()) {
            return;
        }
        System.out.println("Will kick player ID " + id);
        try {
            this.Out.writeBytes("/kickid " + id + "\n");
        }
        catch (IOException ex) {
            Logger.getLogger(KagServer.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void banPlayer(int id) {
        if (!this.Connected.booleanValue()) {
            return;
        }
        System.out.println("Will ban player ID " + id);
        try {
            this.Out.writeBytes("/banid " + id + "\n");
        }
        catch (IOException ex) {
            Logger.getLogger(KagServer.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Void doInBackground() throws Exception {
        System.out.println("in background");
        if (this.Connected.booleanValue()) {
            System.out.println("Already connected?");
            return null;
        }
        this.Connect();
        ArrayList<KagPlayer> foundPlayers = new ArrayList<KagPlayer>();
        boolean findingPlayers = false;
        try {
            int i = 0;
            while (true) {
                if (Thread.interrupted()) {
                    System.out.println("got interrupt");
                    throw new InterruptedException();
                }
                if (i % 100 == 0) {
                    System.out.println("Sending keepalive to see if writing fails which means we're disconnected");
                    this.Out.writeBytes("/players\n");
                    this.Out.flush();
                }
                if (!this.In.ready()) {
                    Thread.sleep(100L);
                } else {
                    Matcher playermatcher;
                    String line = this.In.readLine();
                    if (line == null) {
                        break;
                    }
                    if (!this.Connected.booleanValue()) {
                        this.Connected = true;
                        this.publish(KagNotif.eventFactory("Connected"));
                    }
                    if ((playermatcher = KagRegexes.linePlayer.matcher(line = line.trim())) != null && playermatcher.find()) {
                        int playerID = 0;
                        try {
                            playerID = Integer.parseInt(playermatcher.group(2));
                        }
                        catch (NumberFormatException e) {
                            // empty catch block
                        }
                        foundPlayers.add(new KagPlayer(playermatcher.group(1), playerID, playermatcher.group(3), playermatcher.group(4)));
                    } else if (KagRegexes.linePlayersListStart.matcher(line).matches()) {
                        findingPlayers = true;
                    } else {
                        if (foundPlayers.size() > 0) {
                            this.Window.drawKagPlayers(foundPlayers);
                            foundPlayers.clear();
                            findingPlayers = false;
                        } else if (findingPlayers) {
                            findingPlayers = false;
                            this.Window.drawKagPlayers(foundPlayers);
                            foundPlayers.clear();
                        }
                        this.publish(KagNotif.lineFactory(line));
                    }
                }
                ++i;
            }
        }
        catch (IOException e) {
        }
        catch (InterruptedException e) {
            System.out.println("Disconnecting via interrupt");
        }
        finally {
            this.Disconnect();
        }
        return null;
    }

    @Override
    protected void process(List<KagNotif> messages) {
        for (KagNotif notif : messages) {
            if (notif.Type.equals("line")) {
                this.Window.addConsoleLine(notif.Line, "console");
                continue;
            }
            if (notif.Type.equals("event") && notif.Event.equals("Disconnected")) {
                this.Window.onDisconnect();
                continue;
            }
            if (!notif.Type.equals("event") || !notif.Event.equals("Connected")) continue;
            this.Window.onConnect();
        }
    }

    @Override
    public FavoriteServer getFavServer() {
        FavoriteServer fav = new FavoriteServer();
        fav.Ip = this.Host;
        fav.Port = this.Port;
        fav.Password = this.Password;
        fav.Type = ServerType.KAG;
        System.out.println(fav);
        return fav;
    }
}

